<?php

namespace App\Models\Concerns;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Arr;

trait HasLink
{
    public function scopeWithLink(Builder $query, string $link, array|int $ids): Builder
    {
        $ids = Arr::wrap($ids);

        return $query
            ->whereHasMorph(
                'link',
                [$link],
                function (Builder $query) use ($ids) {
                    $query->whereIn('id', $ids);
                }
            );
    }
}
