<?php

namespace App\Models\Concerns;

use Carbon\Carbon;

/**
 * Trait Has2FAAuth.
 */
trait Has2FAAuth
{
    public function requires2FA()
    {
        // We only support email strategy for now
        return (bool) ($this->auth_2fa_strategy == \App\Enums\Auth2FAStrategy::EMAIL->name);
    }

    public function is2FATokenValid($token)
    {
        return ($this->auth_2fa_token_email == $token)
            && ($this->auth_2fa_token_email_expiration > Carbon::now());
    }

    public function generate2FAToken()
    {
        $this->auth_2fa_token_email = rand(100000, 999999);
        $this->auth_2fa_token_email_expiration = Carbon::now()->addHour();

        return $this->auth_2fa_token_email;
    }
}
