<?php

namespace App\Models\Concerns;

use Carbon\Carbon;
use Carbon\CarbonInterface;

trait HandleDateTimeAttributes
{
    /**
     * {@inheritDoc}
     */
    protected function asDateTime($value)
    {
        try {
            $value = parent::asDateTime($value);
        } catch (\Throwable $exception) {
            $value = Carbon::parse($value);
        }

        return $value->timezone(config('app.timezone'));
    }

    /**
     * {@inheritDoc}
     */
    public function getAttributes(): array
    {
        $attributes = parent::getAttributes();
        foreach ($attributes as $key => $value) {
            if ($value instanceof CarbonInterface) {
                $value = $this->asDateTime($value);
            }

            $attributes[$key] = $value;
        }

        return $attributes;
    }
}
