<?php

namespace App\Models\Concerns;

use App\Models\Currency;

trait CachesOrderCurrency
{
    /**
     * Caches the currency rate for the sales order.
     */
    public function cacheCurrencyRate(bool $force = false): void
    {
        $currency = Currency::find($this->currency_id);
        if ((is_null($this->currency_rate) || $force) && $currency) {
            $this->currency_rate = $currency->conversion;
            $this->currency_id_tenant_snapshot = Currency::default()->id;
        }
    }
}
