<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $id
 * @property int $integration_instance_id
 * @property string $url
 * @property string $requestHeaders
 * @property string $requestBody
 * @property int $responseStatusCode
 * @property string $responseHeaders
 * @property string $responseBody
 * @property string $uuid
 * @property Carbon|null $updated_at
 * @property Carbon $created_at
 */
class ApiLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'integration_instance_id',
        'url',
        'requestHeaders',
        'requestBody',
        'responseStatusCode',
        'responseHeaders',
        'responseBody',
        'uuid'
    ];

    protected $casts = [
        'url' => 'string',
        'requestHeaders' => 'array',
        //'requestBody' => 'array', This fields stores other data types such as XML so we can't cast it to array.
        'responseStatusCode' => 'string',
        'responseHeaders' => 'array',
        'responseBody' => 'string',
    ];

    public function save(array $options = [])
    {
        // Cast requestBody to string if it's an array
        if(is_array($this->requestBody)){
            $this->requestBody = json_encode($this->requestBody);
        }
        return parent::save($options);
    }

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(IntegrationInstance::class);
    }
}
