<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

/**
 * Class Addressable.
 *
 *
 * @property int $id
 * @property int $address_id
 * @property int $addressable_id
 * @property string $addressable_type
 * @property int $is_default
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read Address $address
 * @property-read Model $addressable
 */
class Addressable extends Model
{
    protected $guarded = [];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function address(): BelongsTo
    {
        return $this->belongsTo(Address::class);
    }

    public function addressable(): MorphTo
    {
        return $this->morphTo();
    }
}
