<?php

namespace App\Models\Abstractions;

use App\Contracts\FinancialSummaryCalculatorInterface;
use App\Models\ReportingDailyFinancial;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphMany;

abstract class AbstractReportable extends Model implements FinancialSummaryCalculatorInterface
{
    public function reportingDailyFinancials(): MorphMany
    {
        return $this->morphMany(ReportingDailyFinancial::class, 'reportable');
    }
}
