<?php

namespace App\MockSalesChannels;

use App\Integrations\Channel;
use Generator;
use Illuminate\Contracts\Filesystem\FileNotFoundException;

class WooCommerce extends Channel
{
    /**
     * Get Orders from sales channel.
     *
     * @param  null  $options
     *
     * @throws FileNotFoundException
     */
    public function getSalesOrders($options = null): Generator
    {
        $ordersList = collect($this->mocks('woocommerce.orders'));

        /**
         * For initials options.
         */
        $perPage = 10;
        if (empty($options) || ! is_array($options)) {
            $options = [];
        }

        if (empty($options['limit'])) {
            $options['limit'] = $perPage;
        }

        /**
         * Return Orders chunks with limit.
         */
        foreach ($ordersList->chunk($options['limit']) as $chunk_orders) {
            yield $chunk_orders->values()->all();
        }
    }

    /**
     * Check sales channel credentials.
     *
     * @return mixed
     */
    public function checkCredentials()
    {
        // TODO: Implement checkCredentials() method.
    }

    /**
     * Get Products from sales channel.
     *
     * @param  null  $options
     *
     * @throws FileNotFoundException
     */
    public function getProducts($options = null): Generator
    {
        $ordersList = collect($this->mocks('woocommerce.products'));

        /**
         * For initials options.
         */
        $perPage = 10;
        if (empty($options) || ! is_array($options)) {
            $options = [];
        }

        if (empty($options['limit'])) {
            $options['limit'] = $perPage;
        }

        /**
         * Return Orders chunks with limit.
         */
        foreach ($ordersList->chunk($options['limit']) as $chunk_orders) {
            yield $chunk_orders->values()->all();
        }
    }

    public function getCurrentCurrency()
    {
        return 'USD';
    }
}
