<?php

namespace App;

class MessageBag extends \Illuminate\Support\MessageBag
{
    /**
     * Format an array of messages.
     */
    protected function transform($messages, $format, $messageKey): array
    {
        return collect((array) $messages)
            ->map(function ($message) use ($format, $messageKey) {
                // We will simply spin through the given messages and transform each one
                // replacing the :message place holder with the real message allowing
                // the messages to be easily formatted to each developer's desires.

                // overwrite to replace when message is array
                $message = is_array($message) ? $message['message'] : $message;

                return str_replace([':message', ':key'], [$message, $messageKey], $format);
            })->all();
    }
}
