<?php

namespace App\Managers;

use App\Abstractions\SendEmailContextInterface;
use App\Models\PurchaseOrder;
use App\Models\SalesOrder;
use App\Models\StoreEmailTemplate;
use App\Notifications\EmailTemplateNotification;
use Illuminate\Database\Eloquent\Model;

class StoreEmailTemplateManager
{
    public function getModelObjectFromType(string $type, string|int $id): Model
    {
        $model = StoreEmailTemplate::getTemplateModel($type);

        return $model::findOrFail($id);
    }

    public function sendCustomerEmailTemplate(SendEmailContextInterface $model, $subject, $body, $cc = []): bool
    {
        switch (get_class($model)) {
            case SalesOrder::class:
                /** @var SalesOrder $model */
                $from = $model->store->email;
                $model->customer->notify(new EmailTemplateNotification(
                    $model,
                    $subject,
                    $body,
                    $cc,
                    $from),
                ); break;
            case PurchaseOrder::class:
                /** @var PurchaseOrder $model */
                $from = $model->store->email;
                $model->supplier->notify(new EmailTemplateNotification(
                    $model,
                    $subject,
                    $body,
                    $cc,
                    $from),
                ); break;
            default:
                return false;
        }

        return true;
    }
}