<?php

namespace App\Managers;

class FileManager
{
    public function getOldReportFiles(int $days): array
    {
        $path = storage_path('app/public/reports');

        return $this->getOldReportFilesRecursive($path, $days);
    }

    private function getOldReportFilesRecursive($directory, $days, &$results = [])
    {
        if (!$files = scandir($directory))
        {
            return [];
        }

        foreach ($files as $key => $value) {
            $path = $directory.DIRECTORY_SEPARATOR.$value;
            if (! is_dir($path)) {
                if (filemtime($path) < strtotime("-{$days} days")) {
                    $results[] = $path;
                }
            } elseif ($value != '.' && $value != '..') {
                $this->getOldReportFilesRecursive($path, $days, $results);
            }
        }

        return $results;
    }

    public function deleteOldReportFiles(int $days): void
    {
        $oldFiles = $this->getOldReportFiles($days);

        foreach ($oldFiles as $file) {
            // Delete the file
            unlink($file);
        }
    }
}
