<?php

namespace App\Managers;

use Aws\Credentials\Credentials;
use Aws\SecretsManager\SecretsManagerClient;
use Throwable;

class AwsSecretsManager
{
    public static function secrets($key = null): mixed
    {
        $awsClientId     = config('amazon.aws_client_id');
        $awsClientSecret = config('amazon.aws_client_secret');
        $awsSecretId     = config('amazon.aws_secret_manager_name');

        if (!$awsClientId || !$awsClientSecret || !$awsSecretId) {
            return [];
        }

        try {
            $credentials = new Credentials($awsClientId, $awsClientSecret);
            $client      = new SecretsManagerClient([
                'version' => 'latest',
                'region' => config('amazon.regions.NA.awsRegion'),
                'credentials' => $credentials
            ]);
            $result      = $client->getSecretValue([
                'SecretId' => $awsSecretId,
            ]);
            $secrets     = json_decode($result['SecretString'], true);
            if ($key) {
                return $secrets[$key] ?? null;
            }
            return $secrets;
        } catch (Throwable) {
            //
        }

        return [];
    }

    public static function setUpKeys(): void
    {
        $secrets = self::secrets();

        foreach ($secrets as $key => $value) {
            config([strtolower($key) => $value]);
        }
    }
}