<?php

namespace App\Managers;

use App\Abstractions\AdvancedShipmentNoticeInterface;
use App\Models\Warehouse;
use App\Models\WarehouseTransfer;
use App\Notifications\AdvancedShipmentNoticesNotification;

class AdvancedShipmentNoticeManager
{
    public function send(AdvancedShipmentNoticeInterface $order): void
    {
        $isRemoval = $this->isRemovalOrder($order);

        $order->load('productLines');

        if ($isRemoval) {
            $order->load('removalShipments');
        }

        // mapping product lines to the csv file columns
        $lines = $order->productLines->map(function ($item) use ($order, $isRemoval) {
            $item = [
                'SKU' => $item->product->sku,
                'UPC' => $item->product->barcode,
                'Product Name' => $item->product->name,
                'Qty' => $item->quantity,
                'New SKU' => '',
                'Commodity' => '',
                'Declared Value' => $item->product->unit_cost,
                'Bundle' => 'N',
                'Country of Origin' => strtoupper($item->product->defaultSupplierProduct->supplier->address->country ?? 'us')
            ];

            if ($isRemoval) {
                $shipments                             = $order->removalShipments;
                $item['FNSKU']                         = $shipments->firstWhere('sku', $item['SKU'])?->value('fnsku');
                $item['Amazon Condition Evaluated As'] = $shipments->firstWhere('sku',
                    $item['SKU'])?->value('disposition');
            }
            return $item;
        })->toArray();

        // get the array keys (columns names) and added them as the first line
        array_unshift($lines, array_keys($lines[0]));

        $address = $order->getDestinationAddress();

        $address->notify(new AdvancedShipmentNoticesNotification($order, $lines));

        $order->asn_last_sent_at = now();
        $order->save();
    }

    private function isRemovalOrder(AdvancedShipmentNoticeInterface $order): bool
    {
        return ($order instanceof WarehouseTransfer) &&
            $order->fromWarehouse->type === Warehouse::TYPE_AMAZON_FBA;
    }
}