<?php

namespace App\Mail;

use App\Importers\ImportableInterface;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Str;

class ImportCompletedMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public function __construct(protected User $user, protected string $modelClass)
    {
    }

    /**
     * Build the message.
     */
    public function build(): static
    {
        $resource = class_basename($this->modelClass);
        $count = str_word_count($resource);

        if ($count === 1) {
            $resource = Str::plural($resource);
        }

        return $this
            ->from(config('MAIL_FROM_ADDRESS', 'no-reply@sku.io'))
            ->markdown(! empty($this->markdown) ? $this->markdown : 'mail.imports.completed', [
                'resource' => strtolower(Str::title(preg_replace('/(?<=\w)([A-Z])/', ' $1', $resource))),
                'user' => $this->user,
            ])
            ->subject(! empty($this->subject) ? $this->subject : 'Data Import Completed');
    }
}
