<?php

namespace App\Mail;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class Auth2FAToken extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    private User $user;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $user)
    {
        $this->user = $user;
    }

    /**
     * Build the message.
     */
    public function build(): static
    {
        return $this
            ->from(config('MAIL_FROM_ADDRESS', 'no-reply@sku.io'))
            ->markdown('mail.auth-2fa-token', [
                'user' => $this->user,
            ])
            ->subject('SKU.io login temporary code');
    }
}
