<?php

namespace App\Listeners;

use App\Events\CustomPurchaseInvoiceCreated;
use App\Helpers;
use App\Models\FifoLayer;

class UpdateProductCost
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(CustomPurchaseInvoiceCreated $event): void
    {
        /**
         * Load purchase invoice relations and get total of custom line.
         */
        $event->purchaseInvoice->load(
            'purchaseInvoiceLines',
            'purchaseOrder',
            'purchaseOrder.fifoLayers',
            'purchaseOrder.fifoLayers.product'
        );
        $customTotalLine = $event->purchaseInvoice->purchaseInvoiceLines->first()->total;

        /**
         * Total cost of purchase order layers.
         */
        $total_cost_layers = array_sum(array_column($event->purchaseInvoice->purchaseOrder->fifoLayers->toArray(), 'total_cost'));

        foreach ($event->purchaseInvoice->purchaseOrder->fifoLayers as $fifoLayer) {
            $layer_average = $fifoLayer->total_cost / $total_cost_layers;
            $layer_custom_total = $layer_average * $customTotalLine;
            $layer_total_cost = $fifoLayer->total_cost + $layer_custom_total;

            /**
             * Update total cost of layer.
             */
            // If total cost changes after FIFO layer is completely fulfilled
            if ($fifoLayer->fulfilled_quantity == $fifoLayer->original_quantity) {
                // The difference in cost is completely classified as “product overhead”
                // TODO: How to classified as “product overhead”
            } // If total cost changes when FIFO layer is completely unfulfilled
            elseif ($fifoLayer->fulfilled_quantity == 0) {
                $fifoLayer->total_cost = $layer_total_cost;
            } // If total cost changes after FIFO layer is partially fulfilled
            else {
                // A new layer is created for the unfulfilled quantity at the new prorated total cost
                $newFifoLayer = new FifoLayer();
                $newFifoLayer->fifo_layer_date = $fifoLayer->fifo_layer_date;
                $newFifoLayer->product_id = $fifoLayer->product_id;
                $newFifoLayer->original_quantity = $fifoLayer->available_quantity;
                $newFifoLayer->fulfilled_quantity = 0;
                $newFifoLayer->total_cost = $layer_total_cost;
                $event->purchaseInvoice->fifoLayers()->save($newFifoLayer);

                // The difference between the prorated new cost and prorated old cost on the fulfilled quantity is considered "product overhead"
                //        $difference_cost = $newFifoLayer->total_cost - $fifoLayer->total_cost;
                // TODO: How to get The difference between it ?
                // TODO: How to classified as “product overhead” ?

                $fifoLayerAvgCost = $fifoLayer->total_cost / $fifoLayer->available_quantity;
                // The old total cost is updated to the prorated amount for the fulfilled quantity
                $fifoLayer->total_cost = $fifoLayerAvgCost * $fifoLayer->fulfilled_quantity;
                // The original quantity is reduced to the fulfilled quantity
                $fifoLayer->original_quantity = $fifoLayer->fulfilled_quantity;
            }
            $fifoLayer->save();

            /**
             * Update product average cost.
             */
            Helpers::updateProductAverageCostCustomFees($fifoLayer->product_id, $layer_custom_total);
        }
    }
}
