<?php

namespace Tests\App\Lib\DataList;

use App\Lib\DataList\DataListHelper;
use Tests\TestCase;

class DataListHelperTest extends TestCase
{
    /**
     * @group testnow
     */
    public function test_trim_array(): void
    {
        $inputArray = [
            '   spaces   ',
            'no spaces',
            "\t tabs \t",
            "\n new lines \r\n",
        ];

        $expected = [
            'spaces',
            'no spaces',
            'tabs',
            'new lines',
        ];

        $this->assertEquals(
            $expected,
            DataListHelper::trimArray($inputArray),
        );
    }
}
