<?php

namespace App\Lib\DataList;

use Spatie\SimpleExcel\SimpleExcelReader;

/**
 * Wrapper for https://github.com/spatie/simple-excel
 *
 * @deprecated This simple-excel might not be installed in composer.json at the moment
 */
class SimpleExcelDataList implements DataListInterface
{
    protected $simpleExcelReader;

    public function __construct(
        string $filePath,
        string $fileType = '', // See \OpenSpout\Common\Type  if arg is excluded then the library will guess accurately
        string $delimiter = ','
    ) {
        $this->simpleExcelReader = SimpleExcelReader::create($filePath, $fileType)->trimHeaderRow();
        $this->simpleExcelReader->useDelimiter($delimiter);
    }

    public function getColumnHeadings(): array
    {
        return $this->simpleExcelReader->getHeaders();
    }

    public function getRows(): \Generator
    {
        foreach ($this->simpleExcelReader->getRows() as $row) {
            yield $row;
        }
    }

    public function getRowCount(): int
    {
        return $this->simpleExcelReader->getRows()->count();
    }
}
