<?php

namespace App\Lib\DataList;

interface DataListInterface
{
    /**
     * It is expected that the implementation of this will trim white space from the headings
     */
    public function getColumnHeadings(): array;

    /**
     * It is expected that the implementation of this will trim white space from each cell
     */
    public function getRows(): \Generator;

    /**
     * The row count excluding headings and excluding entirely empty blank lines at the end of the file
     */
    public function getRowCount(): int;
}
