<?php

namespace App\Jobs;

use App\Managers\ProductInventoryManager;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Arr;

class UpdateProductsInventoryAndAvgCost implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected null|array|int $productIds;

    protected bool $updateInventory = true;

    protected bool $updateAverageCost = true;

    protected bool $allow_all_products = false;

    /**
     * Create a new job instance.
     *
     * @param  null  $productIds
     */
    public function __construct($productIds = null)
    {
        $this->onQueue('syncInventory');
        $this->productIds = Arr::wrap($productIds);
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        customlog('SKU-5982', 'UpdateProductsInventoryAndAvgCost job started on queue', $this->productIds);
        (new ProductInventoryManager($this->productIds, $this->updateInventory, $this->updateAverageCost, $this->allow_all_products))->updateProductInventoryAndAvgCost();
    }

    /**
     * Determined whether we want to update products inventory or not.
     */
    public function setUpdateInventory(bool $update): static
    {
        $this->updateInventory = $update;

        return $this;
    }

    /**
     * Determined whether we want to update products average cost or not.
     */
    public function setUpdateAverageCost(bool $update): static
    {
        $this->updateAverageCost = $update;

        return $this;
    }

    /**
     * Determined whether we want to allow an update of all produts.
     */
    public function setAllowAllProducts(bool $allow_all_products): static
    {
        $this->allow_all_products = $allow_all_products;

        return $this;
    }
}
