<?php

namespace App\Jobs;

use App\Services\SalesOrder\SalesOrderManager;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

/**
 * Class SyncExternallyFulfilledJob.
 */
class SyncExternallyFulfilledJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(private readonly ?array $ids = [])
    {
    }

    /**
     * Execute the job.
     *
     * @throws Exception
     */
    public function handle(): void
    {
        app(SalesOrderManager::class)->syncExternallyFulfilled($this->ids);
    }
}
