<?php

namespace App\Jobs;

use App\Services\InventoryManagement\BackorderManager;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use romanzipp\QueueMonitor\Traits\IsMonitored;

class SyncBackorderQueueCoveragesJob implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use IsMonitored;
    use Queueable;
    use SerializesModels;

    private bool $allowGlobalCoverage = false;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(
        private readonly ?array $purchaseOrderLineIds = null,
        private readonly ?array $backorderQueueIds = null,
        private readonly ?array $productIds = null,
        private readonly ?int $warehouseId = null,
    ) {
        $this->onQueue('backorderCoverage');
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $manager = new BackorderManager;
        if ($this->allowGlobalCoverage) {
            $manager->withGlobalCoverage();
        }
        $manager->coverBackorderQueues($this->purchaseOrderLineIds, $this->backorderQueueIds, $this->productIds, $this->warehouseId);
    }

    public function withGlobalCoverage(): self
    {
        $this->allowGlobalCoverage = true;

        return $this;
    }
}
