<?php

namespace App\Jobs\Starshipit;

use App\Integrations\Starshipit;
use App\Models\IntegrationInstance;
use App\Models\Starshipit\StarshipitOrder;
use App\SDKs\Starshipit\StarshipitException;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class GetOrder implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $tries = 50;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(protected StarshipitOrder $order, protected ?IntegrationInstance $integrationInstance = null)
    {
        //
    }

    /**
     * Execute the job.
     *
     * @throws StarshipitException
     */
    public function handle(): void
    {
        $starshipit = new Starshipit($this->integrationInstance ?: IntegrationInstance::starshipit()->firstOrFail());
        try {
            $getOrderResponse = $starshipit->getOrder($this->order->order_id);
        } catch (StarshipitException $e) {
            // the last attempt
            if ($this->attempts() == $this->tries) {
                $this->order->json_object = array_merge($this->order->json_object, ['sync_status' => 'failed', 'errors' => $e->getMessage()]);
                throw $e;
            } else {
                $this->order->json_object = array_merge($this->order->json_object, ['sync_status' => 'syncing', 'errors' => $e->getMessage()]);

                $this->release($this->backoff());

                return;
            }
        }

        if ($getOrderResponse->statusCode == 200 && $getOrderResponse->body['success']) {
            $this->order->json_object = array_merge($this->order->json_object, ['sync_status' => 'success', 'errors' => null]);
            $this->order->json_object = array_merge($this->order->json_object, $getOrderResponse->body['order']);
            $this->order->save();
        } else {
            $this->order->json_object = array_merge($this->order->json_object, ['sync_status' => 'failed', 'errors' => $getOrderResponse->body]);
        }
    }

    /**
     * Calculate the number of seconds to wait before retrying the job.
     */
    public function backoff(): int
    {
        return $this->attempts() * 60;
    }
}
