<?php

namespace App\Jobs\Starshipit;

use App\Exceptions\IntegrationInstance\Starshipit\CantDeleteStarShipitOrderAlreadyFulfilled;
use App\Integrations\Starshipit;
use App\Models\IntegrationInstance;
use App\Models\SalesOrderFulfillment;
use App\Models\Starshipit\StarshipitOrder;
use App\SDKs\Starshipit\StarshipitException;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class DeleteOrder implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /** @var string */
    protected $salesOrderFulfillment;

    /**
     * Create a new job instance.
     */
    public function __construct(SalesOrderFulfillment $salesOrderFulfillment)
    {
        $this->salesOrderFulfillment = $salesOrderFulfillment;
    }

    /**
     * Execute the job.
     *
     * @throws StarshipitException|CantDeleteStarShipitOrderAlreadyFulfilled|Exception
     */
    public function handle(): void
    {
        $integrationInstance = IntegrationInstance::with([])->starshipit()->firstOrFail();
        $starshipit = new Starshipit($integrationInstance);

        $order = null;

        $order = StarshipitOrder::with([])->where('sku_fulfillment_id', $this->salesOrderFulfillment->id)->first();

        if ($order && $order->order_id) {
            try {
                $deleteOrderResponse = $starshipit->deleteOrder($order->order_id);
                if ($deleteOrderResponse->statusCode == 200) {
                    if (! ($deleteOrderResponse->body['success'] ?? true)) {
                        throw new CantDeleteStarShipitOrderAlreadyFulfilled($deleteOrderResponse->body['errors'][0]['details'] ?? json_encode($deleteOrderResponse->body['errors']));
                    }
                } else {
                    throw new Exception(json_encode($deleteOrderResponse->body), $deleteOrderResponse->statusCode);
                }
            } catch (StarshipitException $exception) {
                // it already doesn't exist in Starshipit
                if ($exception->getCode() == 404) {
                    return;
                }
                /** @see SKU-4543 */
                if ($exception->getCode() == 500 && $exception->getMessage() == 'An error has occurred.') {
                    return;
                }

                throw $exception;
            }
        }
    }
}
