<?php

namespace App\Jobs\Shopify;

use App\Models\IntegrationInstance;
use App\Models\ProductListing;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Shopify\Managers\ShopifyProductManager;
use Throwable;

class ShopifyResetInventoryJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected Throwable $exception;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(protected IntegrationInstance $integrationInstance, protected ProductListing $productListing, protected string $inventoryLocationId)
    {
        $this->onQueue('syncInventory');
    }

    /**
     * Execute the job.
     *
     * @throws Throwable
     */
    public function handle(): void
    {
        (new ShopifyProductManager($this->integrationInstance))->resetInventory($this->productListing, $this->inventoryLocationId);
    }
}
