<?php

namespace App\Jobs\Shopify;

use App\Models\IntegrationInstance;
use App\Repositories\Shopify\ShopifyWebhookEventRepository;
use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Throwable;

class ShopifyProcessWebhooksJob implements ShouldBeUnique, ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $uniqueFor = 60 * 10;

    public function uniqueId(): string
    {
        return 'process-shopify-webhooks-'.$this->integrationInstance->id;
    }

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(protected IntegrationInstance|int $integrationInstance)
    {
        $this->onQueue('sales-channels');
        $this->integrationInstance = $integrationInstance instanceof IntegrationInstance ? $integrationInstance : IntegrationInstance::query()->findOrFail($integrationInstance);
    }

    /**
     * Execute the job.
     *
     * @throws Throwable
     */
    public function handle(): void
    {
        /*
         * Process webhook payloads
         */
        app()->make(ShopifyWebhookEventRepository::class)->process($this->integrationInstance);
    }
}
