<?php

namespace App\Jobs\Shopify;

use App\Jobs\SalesOrderLineMapper;
use App\Jobs\ShipStation\AutoFulfillmentOrder;
use App\Models\SalesOrder;
use App\Models\SalesOrderLine;
use App\Models\Shopify\ShopifyOrder;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;

/**
 * Class MapSalesOrderLines.
 *
 * @deprecated
 */
class ShopifyMapSalesOrderLines extends SalesOrderLineMapper
{
    /**
     * @return ShopifyOrder[]|Builder[]|Collection|mixed
     */
    protected function getOrders()
    {
        $query = ShopifyOrder::query()
            ->where('integration_instance_id', $this->integrationInstance->id)
            ->whereHas('orderLineItems', function (Builder $query) {
                // shopify order line has the same listing variant
                $query->where('variant_id', $this->productListing->sales_channel_listing_id);
                // and this shopify order line has a sku sales order line whose product_id is null
                $query->whereHas('salesOrderLine', function (Builder $builder) {
                    /** @see SKU-4892 we specified that mappings should not affect historical orders that were already mapped (only those needing mapping). */
                    $builder->whereNull('product_id');
                    // to be sure it refers to the correct sales order line
                    $builder->whereColumn('sales_order_lines.sales_order_id', 'shopify_orders.sku_sales_order_id');
                });
            });

        return $query->get();
    }

    /**
     * @param  ShopifyOrder  $shopifyOrder
     */
    public static function handleAfterMapLines(SalesOrder $salesOrder, $shopifyOrder, ?\Illuminate\Support\Collection $skuOrderLines, bool $loadLines = true)
    {
        $loadLines && $salesOrder->load('salesOrderLines');
        // use salesOrderLines because we stop unmap sales order lines
        $productLinesMapped = $salesOrder->salesOrderLines->where('is_product', true)
            ->filter(fn (SalesOrderLine $line) => is_null($line->product_id) || is_null($line->warehouse_id))->isEmpty();

        if ($productLinesMapped && $shopifyOrder) {
            // Attempt to approve the sales order first
            // since it's now coming out of draft mode.
            $salesOrder->approve();
            // We handle the statuses of the order.
            $shopifyOrder->handleOrderStatuses($salesOrder);
        }

        // Auto fulfill the sales order if the warehouses of lines belong to the automated warehouses
        (new AutoFulfillmentOrder($salesOrder))->fulfillOpenOrder();
    }
}
