<?php

namespace App\Jobs\Shopify;

use App\Integrations\Shopify;
use App\Models\IntegrationInstance;
use App\Repositories\Shopify\ShopifyTransactionRepository;
use Exception;
use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\Middleware\WithoutOverlapping;
use Illuminate\Queue\SerializesModels;

/*
 * Now unused since we ar relying on webhook for order transactions for single orders and bulk sync just uses
 * CreateShopifyGetTransactionsBulkOperationJob.  But may have future use.
 */
class ShopifyGetOrderTransactionsJob implements ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 5;

    public function middleware(): array
    {
        return [(new WithoutOverlapping('GetOrderTransactionsJob'))->releaseAfter(30)->expireAfter(120)];
    }

    public function __construct(protected IntegrationInstance|int $integrationInstance, protected int $shopify_order_id)
    {
        $this->integrationInstance = $integrationInstance instanceof IntegrationInstance ? $integrationInstance : IntegrationInstance::query()->findOrFail($integrationInstance);
    }

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        $shopify = new Shopify($this->integrationInstance);

        $data = $shopify->getOrderTransactions($this->shopify_order_id);

        app()->make(ShopifyTransactionRepository::class)->save(
            $this->integrationInstance,
            $this->shopify_order_id, $data['data']['orders']['edges'][0]['node']['transactions']
        );
    }
}
