<?php

namespace App\Jobs\Shopify;

use App\Integrations\Shopify;
use App\Models\IntegrationInstance;
use App\Models\Shopify\ShopifyProduct;
use App\Models\Shopify\ShopifyEvent;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;

/**
 * @deprecated See ShopifyDeleteMissingProductVariantsJob
 */
class ShopifyDeletedProductEventsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * The maximum number of times the job may be attempted.
     *
     * @var int
     */
    public $tries = 3;

    /**
     * @var IntegrationInstance
     */
    protected $integrationInstance;

    public function __construct(IntegrationInstance $integrationInstance)
    {
        $this->integrationInstance = $integrationInstance;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        exit;
        $shopify = new Shopify($this->integrationInstance);

        // Get last processed event timestamp from the shopify_events table
        $lastProcessedEvent = ShopifyEvent::where('subject_type', 'Product')
            ->where('verb', 'destroy')
            ->where('integration_instance_id', $this->integrationInstance->id)
            ->orderByDesc('processed_at')
            ->first();

        // Define the filter and verb parameters
        $filter = 'Product';
        $verb = 'destroy';

        $lastProcessedTimestamp = null;

        // Set the created_at_min parameter to only get new events since the last processed event
        if ($lastProcessedEvent) {
            $created_at_min = $lastProcessedEvent->processed_at->format('c');
            $params = ['filter' => $filter, 'verb' => $verb, 'created_at_min' => $created_at_min];
        } else {
            $params = ['filter' => $filter, 'verb' => $verb];
        }

        $response = $shopify->getDeletedEvents($params);
        foreach ($response as $page => $events) {
            if (isset($events['limit'])) {
                continue;
            }
            if (empty($events)) {
                break;
            }

            $data = collect($events)->map(function ($event) {
                $processedAt = new \DateTime($event['created_at']);

                return [
                    'integration_instance_id' => $this->integrationInstance->id,
                    'subject_id' => $event['subject_id'],
                    'subject_type' => $event['subject_type'],
                    'verb' => $event['verb'],
                    'body' => $event['body'],
                    'message' => $event['message'],
                    'author' => $event['author'],
                    'description' => $event['description'],
                    'path' => $event['path'],
                    'processed_at' => $processedAt->format('Y-m-d H:i:s'),
                ];
            });

            ShopifyEvent::upsert($data->all(), [
                'subject_id',
                'subject_type',
                'integration_instance_id',
            ], [
                'verb',
                'body',
                'message',
                'author',
                'description',
                'path',
                'processed_at',
            ], []);
        }
        try {
            DB::beginTransaction();

            $result = ShopifyProduct::where('integration_instance_id',
                $this->integrationInstance->id)
                ->whereIn('product_id',
                    ShopifyEvent::whereNull('sku_processed_at')->where('verb',
                        'destroy')->pluck('subject_id')->toArray())
                ->pluck('variant_id', 'product_id')
                ->map(function ($variant_id, $product_id) {
                    return '('.$variant_id.','.$product_id.')';
                })
                ->values()
                ->toArray();
            //            $UpdateProductVariantShopifyRemoved = new UpdateProductVariantShopifyRemoved();
            //            $num_removed                        = $UpdateProductVariantShopifyRemoved->execute($result,
            //                $this->integrationInstance->id, 1);
            ShopifyEvent::whereNull('sku_processed_at')->where('verb',
                'destroy')->update(['sku_processed_at' => date('Y-m-d H:i:s')]);

            DB::commit();
        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
        }
    }
}
