<?php

namespace App\Jobs\Shopify;

use App\Models\IntegrationInstance;
use App\Services\Shopify\ShopifyProductManager;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use PHPShopify\Exception\ApiException;
use PHPShopify\Exception\CurlException;

class ShopifyDeleteMissingProductVariantsJob implements ShouldBeUnique, ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 0;

    public int $uniqueFor = 60 * 5;

    public function uniqueId(): string
    {
        return 'shopify-delete-missing-product-variants-'.$this->integrationInstance->id;
    }

    /**
     * GetProducts constructor.
     */
    public function __construct(protected IntegrationInstance $integrationInstance)
    {
    }

    /**
     * Execute the job.
     *
     * @throws ApiException
     * @throws CurlException
     */
    public function handle(): void
    {
        if (config('app.env') == 'production') {
            dispatch(new CreateShopifyGetProductVariantsBulkOperationJob($this->integrationInstance));
        } else {
            (new ShopifyProductManager($this->integrationInstance))->deleteMissingProductVariants();
        }
    }
}
