<?php

namespace App\Jobs\Shopify;

use App\Enums\Shopify\ShopifyBulkOperationTypeEnum;
use App\Exceptions\IntegrationInstance\Shopify\GraphqlError;
use App\Repositories\Shopify\ShopifyBulkOperationRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

trait ShopifyBulkOperationTrait
{
    public function handleBulkOperationResponse(array $response, ShopifyBulkOperationTypeEnum $operationType): void
    {
        if (empty($response['data']['bulkOperationRunQuery'])) {
            Log::debug('Bulk operation error:', $response);

            return;
        }

        if (! empty($response['data']['bulkOperationRunQuery']['userErrors'])) {
            $firstErrorMessage = $response['data']['bulkOperationRunQuery']['userErrors'][0]['message'];
            /** @see SKU-5062 the job should release with a 5 minutes delay */
            if (Str::contains($firstErrorMessage, 'already in progress')) {
                $this->release(60 * 5);

                return;
            }

            throw new GraphqlError($firstErrorMessage, $response);
        }

        $data = [
            'admin_graphql_api_id' => $response['data']['bulkOperationRunQuery']['bulkOperation']['id'],
            'created_at' => Carbon::now(), // overwritten by api in update
            'status' => $response['data']['bulkOperationRunQuery']['bulkOperation']['status'],
            'operation_type' => $operationType->value,
            'type' => 'query',
        ];

        app(ShopifyBulkOperationRepository::class)->create($this->integrationInstance, $data);
    }
}
