<?php

namespace App\Jobs\Shopify;

use App\Models\Shopify\ShopifyBulkOperation;
use Exception;
use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;

class ReformatShopifyOrderTransactionsJSONLJob implements ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(protected ShopifyBulkOperation $bulkOperation)
    {
        //
    }

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        //Log::info('Processing JSONL '.$this->bulkOperation->filename);

        $order_id_prefix_pattern = "/^.*gid:\\\\\/\\\\\/shopify\\\\\/Order\\\\\/([0-9]*).*$/";

        $this->bulkOperation->reformatted_filename = 'import-'.$this->bulkOperation->filename;

        $fh_read = fopen(Storage::disk('shopify')->path('').$this->bulkOperation->filename, 'r');

        /*
         * This needed to make sure permissions set right
         */
        Storage::disk('shopify')->put($this->bulkOperation->reformatted_filename, '');
        $fh_write = fopen(Storage::disk('shopify')->path('').$this->bulkOperation->reformatted_filename, 'w');

        if ($fh_read) {
            while (($line = fgets($fh_read)) !== false) {
                if (substr($line, 24, 5) == 'Order') {
                    $matches = [];
                    if (preg_match($order_id_prefix_pattern, substr($line, 5), $matches) === 0) {
                        throw new Exception('Error parsing line of JSONL while trying to find order id');
                    }
                    fwrite($fh_write, json_encode('{"shopify_order_id":'.$matches[1].',"admin_graphql_api_id"'.$matches[0])."\n");
                } else {
                    throw new Exception('Unexpected line');
                }
            }
            fclose($fh_read);
            fclose($fh_write);

            $this->bulkOperation->update();
        }
    }
}
