<?php

namespace App\Jobs\Shopify;

use App\Models\Shopify\ShopifyBulkOperation;
use Exception;
use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;

class ReformatShopifyOrderJSONLJob implements ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(protected ShopifyBulkOperation $bulkOperation)
    {
        //
    }

    /*public function middleware(): array
    {
        return [(new WithoutOverlapping('ReformatShopifyOrderJSONLJob'))->releaseAfter(60)->expireAfter(300)];
    }*/

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        //Log::info('Processing JSONL '.$this->bulkOperation->filename);

        $order_id_prefix_pattern = "/^.*gid:\\\\\/\\\\\/shopify\\\\\/Order\\\\\/([0-9]*).*$/";
        $line_item_prefix_pattern = "/^.*gid:\\\\\/\\\\\/shopify\\\\\/LineItem\\\\\/([0-9]*).*$/";
        $line_item_parent_id_prefix_pattern = "/^.*__parentId\":\"gid:\\\\\/\\\\\/shopify\\\\\/Order\\\\\/([0-9]*).*$/";

        $order_id = null;

        $this->bulkOperation->reformatted_filename = 'import-'.$this->bulkOperation->filename;

        $fh_read = fopen(Storage::disk('shopify')->path('').$this->bulkOperation->filename, 'r');

        /*
         * This needed to make sure permissions set right
         */
        Storage::disk('shopify')->put($this->bulkOperation->reformatted_filename, '');
        $fh_write = fopen(Storage::disk('shopify')->path('').$this->bulkOperation->reformatted_filename, 'w');

        if ($fh_read) {
            while (($line = fgets($fh_read)) !== false) {
                if (substr($line, 24, 5) == 'Order') {
                    if (isset($json_object)) {
                        $json_object = json_encode(substr($json_object, 0, -1).',"line_items":['.implode(',', $line_items).']}')."\n";
                        fwrite($fh_write, $json_object);
                        echo ".\n";
                    }
                    $line_items = [];
                    $matches = [];
                    if (preg_match($order_id_prefix_pattern, substr($line, 5), $matches) === 0) {
                        throw new Exception('Error parsing line of JSONL while trying to find order id');
                    }
                    $order_id = $matches[1];
                    $json_object = '{"id":'.$order_id.',"admin_graphql_api_id"'.$matches[0];
                } elseif (substr($line, 24, 8) == 'LineItem') {
                    $matches = [];
                    if (preg_match($line_item_prefix_pattern, substr($line, 5), $matches) === 0) {
                        throw new Exception('Error parsing line of JSONL while trying to find line item id');
                    }
                    $line_id = $matches[1];

                    if (preg_match($line_item_parent_id_prefix_pattern, substr($line, 5), $matches) === 0) {
                        throw new Exception('Error parsing line of JSONL while trying to find parent of line item id');
                    }
                    $parent_id = $matches[1];

                    if ($parent_id != $order_id) {
                        throw new Exception('Order line items out of order for line '.$line_id.' and parent '.$parent_id);
                    }

                    $line_items[] = '{"id":'.$line_id.',"admin_graphql_api_id"'.preg_replace('/,"__parentId".*/', '', $matches[0]).'}';
                } else {
                    throw new Exception('Unexpected line');
                }
            }
            fclose($fh_read);
            fclose($fh_write);

            $this->bulkOperation->update();
        }
    }
}
