<?php

namespace App\Jobs\Shopify;

use App\Models\Shopify\ShopifyBulkOperation;
use App\Repositories\Shopify\ShopifyProductRepository;
use App\Services\Shopify\ShopifyProductManager;
use Exception;
use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Throwable;

class ProcessShopifyProductVariantsBulkOperationJob implements ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private ShopifyProductRepository $shopifyProductRepository;

    public function __construct(protected ShopifyBulkOperation $bulkOperation)
    {
        $this->onQueue('sales-channels');
        $this->shopifyProductRepository = app(ShopifyProductRepository::class);
    }

    /**
     * @throws Exception
     * @throws Throwable
     */
    public function handle(): void
    {
        $shopifyProductManager = new ShopifyProductManager($this->bulkOperation->integrationInstance);

        $shopifyProductVariantIds = $shopifyProductManager->getProductVariationIdsFromJSONL($this->bulkOperation);
        //Log::info('product variant ids ' . count($shopifyProductVariantIds));
        //Log::info('marking product variants active from shopify');
        $shopifyProductManager->markProductVariantsActiveFromShopify($shopifyProductVariantIds);
        //Log::info('marking product variants removed that exist in sku but missing from shopify');
        $shopifyProductManager->markProductVariantsRemovedThatExistInSkuButMissingFromShopify($shopifyProductVariantIds);
        /*
         * I don't think users want to remove mappings just because a product is removed from shopify.  What if they need
         * to import historical records?  It is better to force user to manually delete listings.
         */
        //dispatch(new ShopifyDeleteProductListingsRemovedFromShopifyJob($this->bulkOperation->integrationInstance))->onQueue('sales-channels');
    }
}
