<?php

namespace App\Jobs\ShipStation;

use App\Models\IntegrationInstance;
use App\SDKs\ShipStation\Model\ShipStationWebhook;
use App\SDKs\ShipStation\Requests\WebhooksShipmentsRequest;
use App\SDKs\ShipStation\ShipStationException;
use App\Services\ShippingProvider\ShipStationManager;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ShipStationHandleWebhookJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected IntegrationInstance $integrationInstance;

    protected ShipStationWebhook $webhook;

    protected WebhooksShipmentsRequest $webhooksShipmentsRequest;

    /**
     * Create a new job instance.
     */
    public function __construct(IntegrationInstance $integrationInstance, ShipStationWebhook $webhook)
    {
        $this->integrationInstance = $integrationInstance;
        $this->webhook = $webhook;
        $this->webhooksShipmentsRequest = new WebhooksShipmentsRequest();
    }

    /**
     * Execute the job.
     *
     * @throws ShipStationException
     * @throws BindingResolutionException
     * @throws Exception
     */
    public function handle(): void
    {
        set_time_limit(0);
        (new ShipStationManager())->handleShipStationWebhook($this->integrationInstance, $this->webhook);
    }
}
