<?php

namespace App\Jobs\ShipStation;

use App\Models\IntegrationInstance;
use App\Models\IntegrationShippingMethod;
use App\Models\ShippingCarrier;
use App\Models\ShippingMethod;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Artisan;

class SeedShippingServiceMapping implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /** @var IntegrationInstance */
    protected $integrationInstance;

    /**
     * Create a new job instance.
     */
    public function __construct(IntegrationInstance $integrationInstance)
    {
        $this->integrationInstance = $integrationInstance;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        // Re-run shipping carrier seeders to fill in
        // any deleted core shipping carrier.
        Artisan::call('db:seed', [
            '--class' => \Database\Seeders\InitialData\ShippingCarriersSeeder::class,
        ]);

        $shippingCarriers = ShippingCarrier::with([])->get();
        $fedexId = $shippingCarriers->firstWhere('name', 'FedEx')->id;
        $upsId = $shippingCarriers->firstWhere('name', 'UPS')->id;
        $uspsId = $shippingCarriers->firstWhere('name', 'USPS')->id;

        $shippingMethods = ShippingMethod::with([])->select('id', 'shipping_carrier_id', 'name', 'type')->get();

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_1_day_freight',
            'shipping_method_id' => $shippingMethods->where('name', '1 Day Freight')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_2_day_freight',
            'shipping_method_id' => $shippingMethods->where('name', '2 Day Freight')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_2day',
            'shipping_method_id' => $shippingMethods->where('name', '2 Day')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_2day_am',
            'shipping_method_id' => $shippingMethods->where('name', '2 Day AM')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_3_day_freight',
            'shipping_method_id' => $shippingMethods->where('name', '3 Day Freight')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_express_saver',
            'shipping_method_id' => $shippingMethods->where('name', 'Express Saver')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_first_overnight',
            'shipping_method_id' => $shippingMethods->where('name', 'First Overnight')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_first_overnight_freight',
            'shipping_method_id' => $shippingMethods->where('name', 'First Overnight Freight')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_ground',
            'shipping_method_id' => $shippingMethods->where('name', 'Ground')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_ground_international',
            'shipping_method_id' => $shippingMethods->where('name', 'Ground International')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_home_delivery',
            'shipping_method_id' => $shippingMethods->where('name', 'Home Delivery')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_international_economy',
            'shipping_method_id' => $shippingMethods->where('name', 'International Economy')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_international_economy_freight',
            'shipping_method_id' => $shippingMethods->where('name', 'International Economy Freight')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_international_first',
            'shipping_method_id' => $shippingMethods->where('name', 'International First')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_international_priority',
            'shipping_method_id' => $shippingMethods->where('name', 'International Priority')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_international_priority_freight',
            'shipping_method_id' => $shippingMethods->where('name', 'International Priority Freight')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_priority_overnight',
            'shipping_method_id' => $shippingMethods->where('name', 'Priority Overnight')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'fedex_standard_overnight',
            'shipping_method_id' => $shippingMethods->where('name', 'Standard Overnight')->where('shipping_carrier_id', $fedexId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'ups_2nd_day_air',
            'shipping_method_id' => $shippingMethods->where('name', '2nd Day Air')->where('shipping_carrier_id', $upsId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'ups_2nd_day_air_am',
            'shipping_method_id' => $shippingMethods->where('name', '2nd Day Air AM')->where('shipping_carrier_id', $upsId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'ups_2nd_day_air_international',
            'shipping_method_id' => $shippingMethods->where('name', '2nd Day Air International')->where('shipping_carrier_id', $upsId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'ups_3_day_select',
            'shipping_method_id' => $shippingMethods->where('name', '3 Day Select')->where('shipping_carrier_id', $upsId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'ups_ground',
            'shipping_method_id' => $shippingMethods->where('name', 'Ground')->where('shipping_carrier_id', $upsId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'ups_ground_international',
            'shipping_method_id' => $shippingMethods->where('name', 'Ground International')->where('shipping_carrier_id', $upsId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'ups_next_day_air',
            'shipping_method_id' => $shippingMethods->where('name', 'Next Day Air')->where('shipping_carrier_id', $upsId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'ups_next_day_air_early_am',
            'shipping_method_id' => $shippingMethods->where('name', 'Next Day Air Early AM')->where('shipping_carrier_id', $upsId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'ups_next_day_air_international',
            'shipping_method_id' => $shippingMethods->where('name', 'Next Day Air International')->where('shipping_carrier_id', $upsId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'ups_next_day_air_saver',
            'shipping_method_id' => $shippingMethods->where('name', 'Next Day Air Saver')->where('shipping_carrier_id', $upsId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'ups_standard_international',
            'shipping_method_id' => $shippingMethods->where('name', 'Standard International')->where('shipping_carrier_id', $upsId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'ups_worldwide_expedited',
            'shipping_method_id' => $shippingMethods->where('name', 'Worldwide Expedited')->where('shipping_carrier_id', $upsId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'ups_worldwide_express',
            'shipping_method_id' => $shippingMethods->where('name', 'Worldwide Express')->where('shipping_carrier_id', $upsId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'ups_worldwide_express_plus',
            'shipping_method_id' => $shippingMethods->where('name', 'Worldwide Express Plus')->where('shipping_carrier_id', $upsId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'ups_worldwide_saver',
            'shipping_method_id' => $shippingMethods->where('name', 'Worldwide Saver')->where('shipping_carrier_id', $upsId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'usps_first_class_mail',
            'shipping_method_id' => $shippingMethods->where('name', 'First Class Mail')->where('shipping_carrier_id', $uspsId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'usps_first_class_mail_international',
            'shipping_method_id' => $shippingMethods->where('name', 'First Class Mail International')->where('shipping_carrier_id', $uspsId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'usps_media_mail',
            'shipping_method_id' => $shippingMethods->where('name', 'Media Mail')->where('shipping_carrier_id', $uspsId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'usps_parcel_select',
            'shipping_method_id' => $shippingMethods->where('name', 'Parcel Select')->where('shipping_carrier_id', $uspsId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'usps_priority_mail',
            'shipping_method_id' => $shippingMethods->where('name', 'Priority Mail')->where('shipping_carrier_id', $uspsId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'usps_priority_mail_express',
            'shipping_method_id' => $shippingMethods->where('name', 'Priority Mail Express')->where('shipping_carrier_id', $uspsId)->first()->id,
        ], [
            'is_domestic' => true,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'usps_priority_mail_express_international',
            'shipping_method_id' => $shippingMethods->where('name', 'Priority Mail Express International')->where('shipping_carrier_id', $uspsId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);

        IntegrationShippingMethod::with([])->updateOrCreate([
            'integration_instance_id' => $this->integrationInstance->id,
            'code' => 'usps_priority_mail_international',
            'shipping_method_id' => $shippingMethods->where('name', 'Priority Mail International')->where('shipping_carrier_id', $uspsId)->first()->id,
        ], [
            'is_domestic' => false,
        ]);
    }
}
