<?php

namespace App\Jobs\ShipStation;

use App\Exceptions\IntegrationInstance\Shipstation\CantDeleteShipstationOrderAlreadyFulfilled;
use App\Integrations\ShipStation;
use App\Models\IntegrationInstance;
use App\Models\SalesOrderFulfillment;
use App\Models\ShipStation\ShipstationOrder;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class DeleteOrder implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected SalesOrderFulfillment $salesOrderFulfillment;

    /**
     * Create a new job instance.
     */
    public function __construct(SalesOrderFulfillment $salesOrderFulfillment)
    {
        $this->salesOrderFulfillment = $salesOrderFulfillment;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $integrationInstance = IntegrationInstance::shipstation()->first();
        $shipStation = new ShipStation($integrationInstance);

        $order = ShipstationOrder::with([])->where('sku_fulfillment_id', $this->salesOrderFulfillment->id)->first();

        if ($order) {
            try {
                $shipstationOrder = $shipStation->getOrder($order->orderId);
                if ($shipstationOrder['orderStatus'] == 'shipped') {
                    throw new CantDeleteShipstationOrderAlreadyFulfilled('Order has already been shipped');
                }
                $shipStation->deleteOrders($order->orderId);
            } catch (\Exception $exception) {
                // 401 Unauthorized
                if ($exception->getCode() == 401) {
                    $integrationInstance->unauthorizedConnection();
                }

                if ($exception->getCode() != 404) {
                    throw $exception;
                }
            }
        }
    }
}
