<?php

namespace App\Jobs;

use App\Repositories\SalesOrderLineFinancialsRepository;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class SeedMissingSalesOrderLineFinancialsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle(): void
    {
        if (config('app.env') == 'testing') {
            return;
        }
        app(SalesOrderLineFinancialsRepository::class)->seedMissingSalesOrderLineFinancials();
        Log::info('Seeding completed.');
    }
}
