<?php

namespace App\Jobs;

use App\Services\FinancialManagement\SalesOrderLineFinancialManager;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;

class RecalculateSalesOrderLineFinancialsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(private readonly Collection $salesOrderLines)
    {
        $this->onQueue('financials');
    }

    public function handle(): void
    {
        app(SalesOrderLineFinancialManager::class)->recalculateLines($this->salesOrderLines);
    }
}
