<?php

namespace App\Jobs;

use App\Managers\FifoLayerManager;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class RecalculateFifoLayerCostsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(private readonly array $ids, private readonly array $parameters)
    {
        $this->onQueue('recalculations');
    }

    public function handle(): void
    {
        (new FifoLayerManager())->recalculateTotalCosts($this->ids, $this->parameters);
    }
}
