<?php

namespace App\Jobs;

use App\Services\FinancialManagement\DailyFinancialManager;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;

class RecalculateDailyFinancialsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(private readonly Collection $dailyFinancials)
    {
        $this->onQueue('financials');
    }

    public function handle(): void
    {
        app(DailyFinancialManager::class)->recalculateDailyFinancials($this->dailyFinancials);
    }
}
