<?php

namespace App\Jobs;

use App\Repositories\DailyFinancialRepository;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Symfony\Component\Console\Helper\ProgressBar;

class RecacheProfitReportingJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected ProgressBar $bar;

    private DailyFinancialRepository $dailyFinancialRepository;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(protected array $productIds = [])
    {
        $this->dailyFinancialRepository = app(DailyFinancialRepository::class);
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $this->dailyFinancialRepository->deleteAllDailyReportsForProducts($this->productIds);
    }

    public function setProgressBar(ProgressBar $bar): static
    {
        $this->bar = $bar;

        return $this;
    }
}
