<?php

namespace App\Jobs\Magento;

use App\Integrations\Magento;
use App\Models\IntegrationInstance;
use App\Models\Magento\Store as MagentoStore;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class GetStores implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $integrationInstance;

    protected $searchCriteria = [];

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(IntegrationInstance $integrationInstance, array $searchCriteria = [])
    {
        $this->integrationInstance = $integrationInstance;
        $this->searchCriteria = $searchCriteria;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        set_time_limit(0);
        if (function_exists('pcntl_async_signals')) {
        }

        $magento = new Magento($this->integrationInstance);

        $stores = $magento->getStores($this->searchCriteria);

        foreach ($stores as $store) {
            $this->createByArray($store);
        }
    }

    private function createByArray($magentoStore)
    {
        $product = MagentoStore::updateOrCreate(
            ['integration_instance_id' => $this->integrationInstance->id, 'code' => $magentoStore['code'], 'magento_id' => $magentoStore['id']],
            [
                'integration_instance_id' => $this->integrationInstance->id,
                'magento_id' => $magentoStore['id'],
                'name' => $magentoStore['website_name'].' - '.$magentoStore['store_name'].' - '.$magentoStore['view_name'],
                'code' => $magentoStore['code'],
                'json_object' => json_encode($magentoStore['json_object']),
            ]
        );
    }
}
