<?php

namespace App\Jobs;

use App\Actions\TakeInventorySnapshot;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Arr;

class InventorySnapshotJob implements ShouldBeUnique, ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected int $timeout = 5 * 60;

    protected int $uniqueFor;

    protected int|array $productIds;

    /**
     * Create a new job instance.
     */
    public function __construct(array $productIds = [])
    {
        $this->productIds = Arr::wrap($productIds);
        $this->uniqueFor = $this->timeout;
    }

    public function uniqueId(): string
    {
        return 'inventory-snapshot';
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        (new TakeInventorySnapshot($this->productIds))->handle();
    }
}
