<?php

namespace App\Jobs;

use App\Integrations\Listings\AmazonListingImporter;
use App\Integrations\Listings\MagentoListingImporter;
use App\Integrations\Listings\ShopifyListingImporter;
use App\Models\IntegrationInstance;
use App\Models\TaskStatus\TaskStatus;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

/**
 * Class ImportListingMapping.
 */
class ImportListingMapping implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $filePath;

    /**
     * @var IntegrationInstance
     */
    protected $integrationInstance;

    /**
     * @var TaskStatus
     */
    protected $task;

    /**
     * ImportListingMapping constructor.
     */
    public function __construct(IntegrationInstance $integrationInstance, $filePath, TaskStatus $task)
    {
        $this->integrationInstance = $integrationInstance;
        $this->filePath = $filePath;
        $this->task = $task;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        set_time_limit(0);

        if ($this->integrationInstance->isShopify()) {
            $importer = new ShopifyListingImporter($this->task, $this->filePath, $this->integrationInstance);
        } elseif ($this->integrationInstance->isMagento()) {
            $importer = new MagentoListingImporter($this->task, $this->filePath, $this->integrationInstance);
        } else {
            throw new \InvalidArgumentException('Unsupported integration instance');
        }

        $importer->import();
    }
}
