<?php

namespace App\Jobs;

use App\Http\Controllers\Traits\OrdersExports;
use App\Models\SalesOrder;
use App\Services\SalesOrder\SalesOrderManager;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class GenerateSalesOrderInvoice implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, OrdersExports, Queueable, SerializesModels;

    protected SalesOrder $salesOrder;

    /**
     * Create a new job instance.
     */
    public function __construct(SalesOrder $salesOrder)
    {
        $salesOrder->load('salesOrderLines');
        $salesOrder->setAppends(['product_total', 'additional_cost', 'tax_cost', 'total']);
        $this->salesOrder = $salesOrder;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        set_time_limit(0);

        app(SalesOrderManager::class)->generateSalesOrderInvoice($this->salesOrder);
    }
}
