<?php

namespace App\Jobs;

use App\Http\Controllers\Traits\OrdersExports;
use App\Models\SalesCredit;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class GenerateSalesCreditInvoice implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, OrdersExports, Queueable, SerializesModels;

    /**
     * @var SalesCredit
     */
    protected $salesCredit;

    /**
     * Create a new job instance.
     */
    public function __construct(SalesCredit $salesCredit)
    {
        $salesCredit->load('salesCreditLines');
        $salesCredit->setAppends(['product_total', 'discount', 'shipping_cost']);
        $this->salesCredit = $salesCredit;
    }

    /**
     * Execute the job.
     */
    public function handle(): string
    {
        set_time_limit(0);

        return $this->generateJasperReport($this->salesCredit, 'SKU_Sales_Credit.jrxml', "invoice-{$this->salesCredit->sales_credit_number}");
    }
}
