<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;

class GenerateRecalculateDailyFinancialsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(private readonly Collection $dailyFinancials)
    {
        $this->onQueue('financials');
    }

    public function handle(): void
    {
        $this->dailyFinancials->chunk(1000)->each(function (Collection $chunk) {
            dispatch(new RecalculateDailyFinancialsJob($chunk))->onQueue('financials');
        });
    }
}
