<?php

namespace App\Jobs;

use App\Models\PurchaseOrder;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Storage;
use Spatie\Browsershot\Browsershot;
use Spatie\Browsershot\Exceptions\CouldNotTakeBrowsershot;
use Throwable;

class GeneratePurchaseOrderPDF implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $purchaseOrder;

    public $pdfPath;

    /**
     * Create a new job instance.
     */
    public function __construct(PurchaseOrder $purchaseOrder, ?string $pdfPath = null)
    {
        $this->purchaseOrder = $purchaseOrder;
        $this->pdfPath = $pdfPath ?: $this->getDefaultPath();
    }

    /**
     * Get default path for generated PDF file.
     */
    private function getDefaultPath(): string
    {
        $poDisk = Storage::disk('po_pdf');

        $dir = date('Y/m/');

        $poDisk->makeDirectory($dir);

        return $poDisk->path($dir.$this->purchaseOrder->id.'.pdf');
    }

    /**
     * Execute the job.
     *
     * @throws CouldNotTakeBrowsershot
     * @throws Throwable
     */
    public function handle(): void
    {
        $mainContent = view('pdf_templates.purchase_order', ['purchaseOrder' => $this->purchaseOrder])->render();

        Browsershot::html($mainContent)
            ->noSandbox()
            ->showBackground()
            ->format('A4')
            ->save($this->pdfPath);
    }
}
