<?php

namespace App\Jobs;

use App\Repositories\InventoryForecastRepository;
use App\Services\InventoryForecasting\ForecastManager;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ForecastInventoryJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private ForecastManager $manager;

    private InventoryForecastRepository $cache;

    private array $productIds = [];

    /**
     * ForecastInventoryJob constructor.
     */
    public function __construct(ForecastManager $manager, InventoryForecastRepository $cache)
    {
        $this->manager = $manager;
        $this->cache = $cache;
    }

    /**
     * Execute the job.
     * @throws \Throwable
     */
    public function handle(): void
    {
        $this->manager->forecast(productIds: $this->productIds);
    }

    public function withProductIds(int|array $productIds): self
    {
        $this->productIds = (array) $productIds;

        return $this;
    }

    public function failed(Exception $exception)
    {
        // Remove for incomplete suppliers
        $this->cache->clearForIncompleteSuppliers(
            productIds: $this->productIds
        );
    }
}
